*                                                                                  ;
 *    Reading in the 1979 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam79.raw' ;
 
 data one;
 
   infile 'F:\PSID\79FAM.DAT'  lrecl=1039 missover;
   INPUT
   V6301 1-3              V6302 4-7              V6303 8-9
   V6304 10-12            V6305 13-17            V6306 18
   V6307 19               V6308 20               V6309 21
   V6310 22               V6311 23               V6312 24
   V6313 25               V6314 26               V6315 27
   V6316 28               V6317 29-32            V6318 33-36
   V6319 37-42            V6320 43               V6321 44-48
   V6322 49               V6323 50-53            V6324 54
   V6325 55-58            V6326 59-62            V6327 63
   V6328 64               V6329 65               V6330 66-69
   V6331 70               V6332 71-74            V6333 75
   V6334 76-79            V6335 80-84            V6336 85-88
   V6337 89               V6338 90-93            V6339 94
   V6340 95-98            V6341 99               V6342 100-103
   V6343 104              V6344 105-108          V6345 109
   V6346 110-112          V6347 113              V6348 114-117
   V6349 118              V6350 119-122          V6351 123
   V6352 124-127          V6353 128              V6354 129-132
   V6355 133              V6356 134-137          V6357 138
   V6358 139-141          V6359 142              V6360 143
   V6361 144-145          V6362 146              V6363 147-151 .2
   V6364 152-156          V6365 157-160          V6366 161
   V6367 162-165          V6368 166              V6369 167-170
   V6370 171              V6371 172              V6372 173-175
   V6373 176              V6374 177-179          V6375 180
   V6376 181-184          V6377 185              V6378 186-189
   V6379 190              V6380 191-194          V6381 195
   V6382 196-199          V6383 200              V6384 201-202
   V6385 203-206          V6386 207-210          V6387 211-214
   V6388 215-218          V6389 219-223          V6390 224-228
   V6391 229-233          V6392 234              V6393 235-239
   V6394 240-244          V6395 245-248          V6396 249-252
   V6397 253              V6398 254-258          V6399 259
   V6400 260-264          V6401 265-269          V6402 270-273
   V6403 274-277          V6404 278-282          V6405 283-286
   V6406 287-291          V6407 292              V6408 293-298
   V6409 299-303          V6410 304              V6411 305-309
   V6412 310-311          V6413 312-316          V6414 317
   V6415 318-321          V6416 322-326          V6417 327-331
   V6418 332-336          V6419 337-341          V6420 342-345
   V6421 346-350          V6422 351-354          V6423 355-358
   V6424 359-363          V6425 364              V6426 365-369
   V6427 370-373          V6428 374-378          V6429 379
   V6430 380              V6431 381-385          V6432 386-390
   V6433 391-395          V6434 396-400          V6435 401-405
   V6436 406-410          V6437 411-415          V6438 416-419
   V6439 420-424          V6440 425-428          V6441 429-432
   V6442 433-437          V6443 438              V6444 439
   V6445 440              V6446 441-444          V6447 445-448
   V6448 449-452          V6449 453-456          V6450 457-460
   V6451 461-464          V6452 465-468          V6453 469-472
   V6454 473-476          V6455 477-480          V6456 481-484
   V6457 485-488          V6458 489-490          V6459 491
   V6460 492-494          V6461 495-496          V6462 497-498
   V6463 499              V6464 500-501          V6465 502-503
   V6466 504-505          V6467 506              V6468 507
   V6469 508              V6470 509              V6471 510
   V6472 511              V6473 512              V6474 513-517
   V6475 518              V6476 519              V6477 520
   V6478 521              V6479 522              V6480 523
   V6481 524-525          V6482 526              V6483 527
   V6484 528              V6485 529-530          V6486 531
   V6487 532              V6488 533              V6489 534
   V6490 535              V6491 536              V6492 537
   V6493 538              V6494 539              V6495 540
   V6496 541              V6497 542-543          V6498 544-545
   V6499 546-548          V6500 549-550          V6501 551
   V6502 552              V6503 553              V6504 554
   V6505 555              V6506 556-557          V6507 558
   V6508 559-560          V6509 561              V6510 562-563
   V6511 564              V6512 565-566          V6513 567
   V6514 568-569          V6515 570-571          V6516 572-573
   V6517 574              V6518 575              V6519 576-579
   V6520 580              V6521 581-584          V6522 585-588
   V6523 589-592          V6524 593              V6525 594-597
   V6526 598              V6527 599-600          V6528 601
   V6529 602-605          V6530 606-607          V6531 608-609
   V6532 610              V6533 611-614          V6534 615
   V6535 616              V6536 617              V6537 618
   V6538 619              V6539 620-621          V6540 622
   V6541 623              V6542 624              V6543 625
   V6544 626              V6545 627-628          V6546 629-632
   V6547 633              V6548 634              V6549 635
   V6550 636              V6551 637-640          V6552 641
   V6553 642-645          V6554 646              V6555 647-648
   V6556 649              V6557 650-651          V6558 652-653
   V6559 654              V6560 655-656          V6561 657
   V6562 658-659          V6563 660              V6564 661-662
   V6565 663              V6566 664-665          V6567 666
   V6568 667-668          V6569 669              V6570 670-671
   V6571 672-673          V6572 674-675          V6573 676-677
   V6574 678              V6575 679              V6576 680-681
   V6577 682              V6578 683-684          V6579 685-686
   V6580 687-688          V6581 689-690          V6582 691
   V6583 692              V6584 693              V6585 694-695
   V6586 696              V6587 697              V6588 698
   V6589 699              V6590 700              V6591 701
   V6592 702              V6593 703              V6594 704
   V6595 705              V6596 706-707          V6597 708-709
   V6598 710-712          V6599 713-714          V6600 715
   V6601 716              V6602 717-718          V6603 719
   V6604 720-721          V6605 722              V6606 723-724
   V6607 725              V6608 726-727          V6609 728
   V6610 729-730          V6611 731-732          V6612 733-734
   V6613 735              V6614 736              V6615 737-740
   V6616 741-744          V6617 745              V6618 746
   V6619 747-748          V6620 749-750          V6621 751-752
   V6622 753-754          V6623 755              V6624 756-757
   V6625 758              V6626 759              V6627 760-761
   V6628 762              V6629 763-764          V6630 765-766
   V6631 767              V6632 768-769          V6633 770
   V6634 771-772          V6635 773              V6636 774-775
   V6637 776              V6638 777-778          V6639 779
   V6640 780-781          V6641 782              V6642 783-784
   V6643 785-786          V6644 787-788          V6645 789-790
   V6646 791              V6647 792              V6648 793-794
   V6649 795              V6650 796-797          V6651 798-799
   V6652 800-801          V6653 802-803          V6654 804
   V6655 805              V6656 806              V6657 807
   V6658 808              V6659 809              V6660 810
   V6661 811              V6662 812              V6663 813-814
   V6664 815-816          V6665 817              V6666 818
   V6667 819              V6668 820              V6669 821
   V6670 822              V6671 823-824          V6672 825
   V6673 826-827          V6674 828              V6675 829-830
   V6676 831              V6677 832-834          V6678 835
   V6679 836              V6680 837              V6681 838
   V6682 839              V6683 840              V6684 841
   V6685 842              V6686 843              V6687 844
   V6688 845              V6689 846              V6690 847
   V6691 848              V6692 849              V6693 850
   V6694 851              V6695 852              V6696 853
   V6697 854              V6698 855              V6699 856-857
   V6700 858-859          V6701 860              V6702 861-862
   V6703 863-864          V6704 865              V6705 866-867
   V6706 868-869          V6707 870              V6708 871
   V6709 872              V6710 873              V6711 874
   V6712 875              V6713 876-877          V6714 878
   V6715 879              V6716 880              V6717 881
   V6718 882              V6719 883              V6720 884-885
   V6721 886-887          V6722 888-889          V6723 890
   V6724 891              V6725 892-893          V6726 894-896
   V6727 897-898          V6728 899-901          V6729 902
   V6730 903              V6731 904              V6732 905-906
   V6733 907-908          V6734 909-910          V6735 911-912
   V6736 913              V6737 914              V6738 915
   V6739 916              V6740 917-918          V6741 919-921
   V6742 922              V6743 923              V6744 924
   V6745 925              V6746 926              V6747 927
   V6748 928              V6749 929              V6750 930-931
   V6751 932-933          V6752 934-935          V6753 936
   V6754 937-938          V6755 939              V6756 940
   V6757 941              V6758 942              V6759 943
   V6760 944              V6761 945              V6762 946
   V6763 947              V6764 948              V6765 949
   V6766 950-954          V6767 955-959          V6768 960-964
   V6769 965-968 .2       V6770 969-972          V6771 973-976 .2
   V6772 977-980 .2       V6773 981              V6774 982
   V6775 983              V6776 984              V6777 985
   V6778 986              V6779 987-988          V6780 989-990
   V6781 991-995          V6782 996              V6783 997-998 .1
   V6784 999-1000         V6785 1001             V6786 1002
   V6787 1003             V6788 1004             V6789 1005-1007
   V6790 1008             V6791 1009             V6792 1010
   V6793 1011             V6794 1012             V6795 1013
   V6796 1014             V6797 1015             V6798 1016
   V6799 1017             V6800 1018             V6801 1019
   V6802 1020             V6803 1021             V6804 1022
   V6805 1023-1024        V6806 1025             V6807 1026
   V6808 1027             V6809 1028             V6810 1029
   V6811 1030             V6812 1031             V6813 1032-1034
   V6814 1035-1038        V6815 1039;

* SAS LABEL STATEMENT;

LABEL
   V6301 = "STUDY #  WAVE12"
   V6302 = "1979 ID"
   V6303 = "CURRENT STATE"
   V6304 = "CURRENT COUNTY"
   V6305 = "CURRENT ST& CNTY  1979"
   V6306 = "SIZE LGST CTY SMSA 1979"
   V6307 = "COLOR OF COVERSHEET 79"
   V6308 = "WHETHER REFUSED 1979"
   V6309 = "TELEPHONE INT ? 1979"
   V6310 = "FAMILY COMP CHNG 1979"
   V6311 = "#MOVED IN 1979"
   V6312 = "WHO MOVED IN 1979"
   V6313 = "# MOVED OUT 1979"
   V6314 = "WHO MOVED OUT 1979"
   V6315 = "CURRENT FAM COMP 1979"
   V6316 = "QUALITY OF MATCH 1979"
   V6317 = "HRS REP VEHICLES (A11)"
   V6318 = "$  SAVED RE VEH (A12-17)"
   V6319 = "1979 HOUSE VALUE (B5)"
   V6320 = "ACC 79 HOUSE VALUE"
   V6321 = "REM MORT PRIN 79 (B7)"
   V6322 = "ACC REM MORT PRIN"
   V6323 = "ANN MORT $  79 (B8)"
   V6324 = "ACC ANN MORT $"
   V6325 = "ANN PROP TAX 79 (B11)"
   V6326 = "ANN RENT 1979 (B12)"
   V6327 = "ACC ANN RENT"
   V6328 = "FURNISHED ? (B13)"
   V6329 = "INCLUDE HEAT ? (B16)"
   V6330 = "ANN $  IF RENT (B18)"
   V6331 = "ACC ANN $  IF RENT"
   V6332 = "ANN UTILITIES 1978"
   V6333 = "ACC ANN UTILITIES"
   V6334 = "HRS REP HOUSE (B29)"
   V6335 = "$  SAVE REP HSE (B30-35)"
   V6336 = "HD ANN WRK HRS IN 78"
   V6337 = "ACC HD 78 WRK HRS"
   V6338 = "HD HRS WRK LOST OTH ILL"
   V6339 = "ACC HD HR LOST OTH ILL"
   V6340 = "HD HRS WRK LOST OWN ILL"
   V6341 = "ACC HD HR LOST OWN ILL"
   V6342 = "HD STRIKE HRS 78"
   V6343 = "ACC HD STRIKE HRS 78"
   V6344 = "HD UNEMP HRS 78"
   V6345 = "ACC HDUNEMP HRS 78"
   V6346 = "HD TRAV TO WRK HRS 78"
   V6347 = "ACC HD TRAV TO WK HRS 78"
   V6348 = "WF ANN WRK HRS IN 78"
   V6349 = "ACC WF 78 WRK HRS"
   V6350 = "WF HRS WRK LOST OTH ILL"
   V6351 = "ACC WF HR LOST OTH ILL"
   V6352 = "WF HRS WRK LOST OWN ILL"
   V6353 = "ACC WF HR LOST OWN ILL"
   V6354 = "WF STRIKE HRS 78"
   V6355 = "ACC WF STRIKE HRS 78"
   V6356 = "WF UNEMP HRS 78"
   V6357 = "ACC WF UNEMP HRS 78"
   V6358 = "WF TRAV TO WRK HRS 78"
   V6359 = "ACC WF TRAV TO WK HRS 78"
   V6360 = "# MAJOR ADULTS"
   V6361 = "1979 FAMILY SIZE"
   V6362 = "# REQUIRED ROOMS 1979"
   V6363 = "1979 WEEKLY FOOD NEED"
   V6364 = "1979 ANN FOOD NEED"
   V6365 = "WF ANN HSEWRK HRS (J5)"
   V6366 = "ACC WF ANN HSEWRK HRS"
   V6367 = "HD ANN HSEWRK HRS (J6)"
   V6368 = "ACC HD ANN HSEWRK HRS"
   V6369 = "OTH ANN HSEWRK HRS (J10)"
   V6370 = "ACC OTH HSEWRK HRS"
   V6371 = "# FD ST ISSUED FOR (J13)"
   V6372 = "$  PD FD ST LAST MO (J14)"
   V6373 = "ACC $  PAID FD ST LAST MO"
   V6374 = "$  BONUS PD LAST MO"
   V6375 = "ACC BONUS FDSTMP LAST MO"
   V6376 = "ANN FD $  EXCL FDSTMP"
   V6377 = "ACC ANN FOOD $"
   V6378 = "ANN $  EATING OUT"
   V6379 = "ACC ANN $  EATING OUT"
   V6380 = "$  PAID FDSTMP 1978"
   V6381 = "ACC $  PAID FDSTMP 1978"
   V6382 = "$  BONUS FDSTMP 1978"
   V6383 = "ACC $  BONUS FDSTMP 1978"
   V6384 = "# MOS USED FDSTMP 78"
   V6385 = "$  SAVED GRWNG OWN FD"
   V6386 = "ANN CHLDCR HRS (J40)"
   V6387 = "ANN $  CHILD CR (J42)"
   V6388 = "ANN EXCHNG HRS CHLDCR"
   V6389 = "LABOR PART FARM Y 1978"
   V6390 = "LABOR PART BUS Y 1978"
   V6391 = "HEAD 1978 WAGES"
   V6392 = "ACC HEAD 1978 WAGES"
   V6393 = "HD BONUS , OT, COMM 1978"
   V6394 = "HD PROF PRAC/TRADE 1978"
   V6395 = "LAB PART MKT GRDNG 1978"
   V6396 = "LAB PART ROOMER 1978"
   V6397 = "ACC HD LABOR Y EXCL WAGE"
   V6398 = "WIFE 1978 LABOR/WAGE"
   V6399 = "ACC WF 78 LABOR/WAGE"
   V6400 = "ASSET PART FARM Y 1978"
   V6401 = "ASSET PART BUS Y 1978"
   V6402 = "ASSET PART MRKT GRD 1978"
   V6403 = "ASSET PART ROOMERS 1978"
   V6404 = "HD RENT, INT DIVIDEND 78"
   V6405 = "ALIMONY Y HEAD 1978"
   V6406 = "WIFE 1978 ASSET Y"
   V6407 = "ACC H+W 1978 ASSET Y"
   V6408 = "H+W 1978 TAXABLE Y"
   V6409 = "H+W 1978 SUPP OTH NONFU"
   V6410 = "H+W 1978 # DEPENDENTS"
   V6411 = "H+W 1978 INCOME TAXES"
   V6412 = "H+W 1978 MARGIN TAX RATE"
   V6413 = "H+W 1978 ADC/AFDC"
   V6414 = "ACC H+W 1978 ADC/AFDC"
   V6415 = "H+W 1978 SSI"
   V6416 = "H+W 1978 OTHER WELFARE"
   V6417 = "H+W 1978 SOCIAL SECURITY"
   V6418 = "HD 1978 OTHER RETIR"
   V6419 = "HD 1978 UNEMP COMP"
   V6420 = "HD 1978 WRKMNS COMP"
   V6421 = "HD 1978 CHLD SUPP"
   V6422 = "HD 1978 HELP FROM REL"
   V6423 = "HD 1978 OTHER TRAN Y"
   V6424 = "WF 1978 OTHER TRAN Y"
   V6425 = "ACC H+W 78 TRAN Y NONADC"
   V6426 = "H+W TOT1978 TRANSFER Y"
   V6427 = "OTH ANN WRK HRS 1978"
   V6428 = "OTH ANN TXBLE Y 78"
   V6429 = "ACC OTH ANN TX Y 78"
   V6430 = "BKT OTH 1978 ASSET Y"
   V6431 = "OTH 1978 TAXES"
   V6432 = "OTH 1978 ADC/AFDC"
   V6433 = "OTH 1978 SSI"
   V6434 = "OTH 1978 OTHER WELFARE"
   V6435 = "OTH 1978 SOCIAL SECURITY"
   V6436 = "OTH 1978 OTHER RET"
   V6437 = "OTH 1978 UNEMP COMP"
   V6438 = "OTH 1978 WRKMNS COMP"
   V6439 = "OTH 1978 CHLD SUPP"
   V6440 = "OTH 1978 HLP FRM RLTVS"
   V6441 = "OTH 1978 MISC TRANS"
   V6442 = "OTH 1978 TOT TRANFER $"
   V6443 = "ACC 78 TOT TRANS $"
   V6444 = "# OTH WITH 78 Y"
   V6445 = "# OTH WITH 78 LABOR Y"
   V6446 = "1968 ID"
   V6447 = "1969 ID"
   V6448 = "1970 ID"
   V6449 = "1971 ID"
   V6450 = "1972 ID"
   V6451 = "1973 ID"
   V6452 = "1974 ID"
   V6453 = "1975 ID"
   V6454 = "1976 ID"
   V6455 = "1977 ID"
   V6456 = "1978 ID"
   V6457 = "INTR ID #"
   V6458 = "INTR INT #"
   V6459 = "DATE OF INT"
   V6460 = "LENGTH OF INT"
   V6461 = "# IN FU"
   V6462 = "AGE OF HEAD"
   V6463 = "SEX OF HEAD"
   V6464 = "AGE OF WIFE"
   V6465 = "# CHILDREN IN FU"
   V6466 = "AGE YOUNGST CHILD"
   V6467 = "A1 PUB TRANS NEARBY?"
   V6468 = "A2 WTR PUB TRANS GD ENUF"
   V6469 = "A3 DU INSIDE CITY LIMITS"
   V6470 = "A4 DIST TO CNTR CITY"
   V6471 = "A5 DIST CNTR NRST CITY"
   V6472 = "A6 OWN CAR/TRUCK"
   V6473 = "A7 # CAR/TRUCK OWN"
   V6474 = "A8 # MI DRIVEN-ALL CARS"
   V6475 = "A9 DO OWN REPAIR-CAR"
   V6476 = "A10 TYPE REPAIR-CAR"
   V6477 = "B1 ACTUAL # ROOMS"
   V6478 = "B2 TYPE DWELLING"
   V6479 = "B3 OWN/RENT OR WHAT"
   V6480 = "B6. MORTGAGE?"
   V6481 = "B9 # YRS LEFT ON MORT"
   V6482 = "B10 2ND MORTGAGE"
   V6483 = "B17 RSN NEITR OWN/RENT"
   V6484 = "B21 MOVE SINCE SPR 1978"
   V6485 = "B22 MONTH MOVE"
   V6486 = "B23 WHY MOVE"
   V6487 = "B24 WTR MIGHT MOVE"
   V6488 = "B25 LIKELY HOOD OF MOVE"
   V6489 = "B26 WHY MIGHT MOVE"
   V6490 = "B27 OWN REPAIR-HOUSE"
   V6491 = "B28 TYPE REPAIR-HOUSE"
   V6492 = "C1 EMP STATUS HEAD"
   V6493 = "C2 WORK SELF/OTR (HD-E)"
   V6494 = "C3 WORK FOR GOVT (HD-E)"
   V6495 = "C4 JOB UNION (HD-E)"
   V6496 = "C5 BLNG THT UNION (HD-E)"
   V6497 = "C6-C7 OCC-2DIG (HD-E)"
   V6498 = "C8 INDUSTRY (HD-E)"
   V6499 = "C9 # MO THIS JOB (HD-E)"
   V6500 = "C11 MO START JOB (HD-E)"
   V6501 = "C12 HPND PREJOB (HD-E)"
   V6502 = "C13 JOB BETTER (HD-E)"
   V6503 = "C14 WHY BET/WRSE (HD-E)"
   V6504 = "C15 JOB PAY MORE (HD-E)"
   V6505 = "C16 WTR OTR ILL (HD-E)"
   V6506 = "C17 #WKS OTR ILL (HD-E)"
   V6507 = "C18 WTR SELF ILL (HD-E)"
   V6508 = "C19 #WKS SELF ILL (HD-E)"
   V6509 = "C20 WTR VACATION (HD-E)"
   V6510 = "C21 #WKS VACAT (HD-E)"
   V6511 = "C22 WTR STRIKE (HD-E)"
   V6512 = "C23 #WKS STRIKE (HD-E)"
   V6513 = "C24 WTR UNEMP (HD-E)"
   V6514 = "C25 #WKS UNEMP (HD-E)"
   V6515 = "C26 # WKS WRKD (HD-E)"
   V6516 = "C27 # HR/WK WRKD (HD-E)"
   V6517 = "C28 WTR WRK OT (HD-E)"
   V6518 = "C30 SLRY/HRLY/OTR (HD-E)"
   V6519 = "C31 PAY/HRLY SLRY (HD-E)"
   V6520 = "C32 WTR PAID OTIME(HD-E)"
   V6521 = "C33 PY/HR SLRY OT (HD-E)"
   V6522 = "C34 PAY/HR HRLY (HD-E)"
   V6523 = "C35 PY/HR HRLY OT (HD-E)"
   V6524 = "C36 HOW PAID (HD-E)"
   V6525 = "C37 PAY/HR OT-OTR (HD-E)"
   V6526 = "C38 WTR XTRA JOBS (HD-E)"
   V6527 = "C39 OCC-XTRA JOB (HD-E)"
   V6528 = "C40 # XTRA JOBS (HD-E)"
   V6529 = "C41 PAY/HR XT JOB (HD-E)"
   V6530 = "C42 #WKS XTRA JOB (HD-E)"
   V6531 = "C43 HR/WK XTR JOB (HD-E)"
   V6532 = "C44 MRE WRK AVAIL (HD-E)"
   V6533 = "C45 PY/HR WK MORE (HD-E)"
   V6534 = "C46 WRK LESS ? (HD-E)"
   V6535 = "C47 WNT WRK LESS (HD-E)"
   V6536 = "C48 WRK MORE ? (HD-E)"
   V6537 = "C49 WRK LESS ? (HD-E)"
   V6538 = "C50 WNT WRK LESS (HD-E)"
   V6539 = "C52 # MI TO WRK (HD-E)"
   V6540 = "C53 MODE TRAV WRK (HD-E)"
   V6541 = "C54 NEW JOB ? (HD-E)"
   V6542 = "C55 LKNG NEW JOB (HD-E)"
   V6543 = "C56 WTR MOV NW JOB(HD-E)"
   V6544 = "C57 WHY NOT MOVE (HD-E)"
   V6545 = "D1 OCC-JOB SOUGHT (HD-U)"
   V6546 = "D2 PY/HR JOB SGHT (HD-U)"
   V6547 = "D3 WTR NEED TRNG (HD-U)"
   V6548 = "D4 WTR LKNG JOB (HD-U)"
   V6549 = "D5 # PLAC LKD (HD-U)"
   V6550 = "D6 JOBS NOT WRTH (HD-U)"
   V6551 = "D7 PAY/HR UNWRTHY (HD-U)"
   V6552 = "D8 WTR MVE FR JOB (HD-U)"
   V6553 = "D9 PAY/HR TO MOVE (HD-U)"
   V6554 = "D10 WHY NOT MOVE (HD-U)"
   V6555 = "D11 WKS LK FR WRK (HD-U)"
   V6556 = "D12 EVER HAD JOB (HD-U)"
   V6557 = "D13 OCC-LAST JOB (HD-U)"
   V6558 = "D14 IND-LAST JOB (HD-U)"
   V6559 = "D15 HPND LAST JOB (HD-U)"
   V6560 = "D16 YR LAST WRKD (HD-U)"
   V6561 = "D18 WTR VACAT (HD-U)"
   V6562 = "D19 # WKS VAC (HD-U)"
   V6563 = "D20 WTR OTR ILL (HD-U)"
   V6564 = "D21 # WKS OTR ILL (HD-U)"
   V6565 = "D22 WTR SELF ILL (HD-U)"
   V6566 = "D23 #WK SELF ILL (HD-U)"
   V6567 = "D24 WTR STRIKE (HD-U)"
   V6568 = "D25 # WKS STRK (HD-U)"
   V6569 = "D26 WTR UNEMP (HD-U)"
   V6570 = "D27 # WKS UNEMP (HD-U)"
   V6571 = "D28 #WKS WRKD (HD-U)"
   V6572 = "D29 HR/WK WRKD (HD-U)"
   V6573 = "D31 # MI TO WRK (HD-U)"
   V6574 = "D32 MODE TRAV WRK (HD-U)"
   V6575 = "E1 RET/HWF DIS ST (HD-R)"
   V6576 = "E2 YR RETIRED (HD-R)"
   V6577 = "E3 WRK FOR $  (HD-R)"
   V6578 = "E4 OCCUPATION (HD-R)"
   V6579 = "E5 INDUSTRY (HD-R)"
   V6580 = "E6 # WKS WRKD (HD-R)"
   V6581 = "E7 HR/WK WRKD (HD-R)"
   V6582 = "E8 WRKNG NOW (HD-R)"
   V6583 = "E9 HPND LST JOB (HD-R)"
   V6584 = "E10 JOB IN FUT (HD-R)"
   V6585 = "E11 WHEN GET JOB (HD-R)"
   V6586 = "E12 TYPE JOB (HD-R)"
   V6587 = "E13 NEED TRNG (HD-R)"
   V6588 = "E14 LK FOR JOB (HD-R)"
   V6589 = "E15 # PLAC LKD (HD-R)"
   V6590 = "F1 WIFE IN FU"
   V6591 = "F2 EMP STATUS WIFE"
   V6592 = "F3 WRK SELF/OTR (WF-E)"
   V6593 = "F4 WRK FOR GOVT (WF-E)"
   V6594 = "F5 JOB UNION (WF-E)"
   V6595 = "F6 BLNG THT UNION (WF-E)"
   V6596 = "F7 OCCUPATION (WF-E)"
   V6597 = "F9 INDUSTRY (WF-E)"
   V6598 = "F10 # MO THIS JOB (WF-E)"
   V6599 = "F12 MO START JOB (WF-E)"
   V6600 = "F13 HPND PREJOB (WF-E)"
   V6601 = "F14 WTR OTR ILL (WF-E)"
   V6602 = "F15 # WKS OTR ILL (WF-E)"
   V6603 = "F16 WTR SELF ILL (WF-E)"
   V6604 = "F17 # WKS SELF ILL(WF-E)"
   V6605 = "F18 WTR VAC (WF-E)"
   V6606 = "F19 # WKS VAC (WF-E)"
   V6607 = "F20 WTR STRIKE (WF-E)"
   V6608 = "F21 # WKS STRIKE (WF-E)"
   V6609 = "F22 WTR UNEMP (WF-E)"
   V6610 = "F23 # WKS UNEMP (WF-E)"
   V6611 = "F24 # WKS WRKD (WF-E)"
   V6612 = "F25 HR/WK WRKD (WF-E)"
   V6613 = "F26 WTR WRK OT (WF-E)"
   V6614 = "F28 SLRY/HRLY/OTR (WF-E)"
   V6615 = "F29 PAY/HRLY SLRY (WF-E)"
   V6616 = "F30 PAY/HR HRLY (WF-E)"
   V6617 = "HOW PAID (WF-E)"
   V6618 = "F31 WTR XTRA JOBS (WF-E)"
   V6619 = "F32 OCC-XTRA JOB (WF-E)"
   V6620 = "F33 #WKS XTRA JOB (WF-E)"
   V6621 = "F34 HR/WK XTR JOB (WF-E)"
   V6622 = "F36 # MI TO WRK (WF-E)"
   V6623 = "F37 MODE TRAV WRK (WF-E)"
   V6624 = "G1 OCC-JOB SOUGHT (WF-U)"
   V6625 = "G2 WTR LKG JOB (WF-U)"
   V6626 = "G3 # PLAC LKD (WF-U)"
   V6627 = "G4 WKS LK FR WRK (WF-U)"
   V6628 = "G5 EVER HAD JOB (WF-U)"
   V6629 = "G6 OCC-LAST JOB (WF-U)"
   V6630 = "G7 IND-LAST JOB (WF-U)"
   V6631 = "G8 HPND LAST JOB (WF-U)"
   V6632 = "G9 YR LAST WRKD (WF-U)"
   V6633 = "G11 WTR VACA (WF-U)"
   V6634 = "G12 # WKS VAC (WF-U)"
   V6635 = "G13 WTR OTR ILL (WF-U)"
   V6636 = "G14 # WKS OTR ILL (WF-U)"
   V6637 = "G15 WTR SELF ILL (WF-U)"
   V6638 = "G16 #WKS SELF ILL (WF-U)"
   V6639 = "G17 WTR STRIKE (WF-U)"
   V6640 = "G18 # WKS STRK (WF-U)"
   V6641 = "G19 WTR UNEMP (WF-U)"
   V6642 = "G20 # WKS UNEMP (WF-U)"
   V6643 = "G21 # WKS WRKD (WF-U)"
   V6644 = "G22 HR/WK WRKD (WF-U)"
   V6645 = "G24 # MI TO WRK (WF-U)"
   V6646 = "G25 MODE TRAV WRK (WF-U)"
   V6647 = "H1 RET/HWF/DIS/ST (WF-R)"
   V6648 = "H2 YR RETIRED (WF-R)"
   V6649 = "H3 WRK FOR $  (WF-R)"
   V6650 = "H4 OCCUPATION (WF-R)"
   V6651 = "H5 INDUSTRY (WF-R)"
   V6652 = "H6 # WKS WRKD (WF-R)"
   V6653 = "H7 HR/WK WRKD (WF-R)"
   V6654 = "H8 WRKNG NOW (WF-R)"
   V6655 = "H9 HPND LST JOB (WF-R)"
   V6656 = "H10 JOB IN FUT (WF-R)"
   V6657 = "H11 LK FOR JOB (WF-R)"
   V6658 = "H12 # PLAC LKD (WF-R)"
   V6659 = "J1 MARRITAL STATUS"
   V6660 = "J2 EVER MARRIED"
   V6661 = "J3 WHT HAPN LST MARR"
   V6662 = "J4 WIFE IN FU"
   V6663 = "J5 # HRS HSWRK-WF"
   V6664 = "J6 # HRS HOWRK-HD"
   V6665 = "J8 OTRS HELP HSWRK"
   V6666 = "J29 RAISE OWN FOOD"
   V6667 = "J36 CHILD UNDER 12 IN FU"
   V6668 = "J37 HD/WF WORKING"
   V6669 = "J38 CHLD CARE FIRST MEN"
   V6670 = "J38 CHLD CARE SEC MEN"
   V6671 = "J40 HRS CARE YNGST"
   V6672 = "J41 PAY FOR CHLD CARE"
   V6673 = "J42 $ /WK CHLD CARE"
   V6674 = "J43 WTR ELSE IN RETURN"
   V6675 = "J44 HR/WK RETURN"
   V6676 = "J45 GOVT PAY?"
   V6677 = "J46 # DAYS STAY HOME"
   V6678 = "K1 HEAD FARMER"
   V6679 = "K2 TOT FARM RECTS (BKT)"
   V6680 = "K5 WTR BUSINESS"
   V6681 = "K6 CORP OR UNINCORP"
   V6682 = "K14 WTR WEL/ADC"
   V6683 = "K15 WEL HELP PAY"
   V6684 = "K16 WHAT PAY FOR"
   V6685 = "K17 RENT PAID DIRECT"
   V6686 = "K56 WTR MEDICAID"
   V6687 = "K57 WHICH PROGRAM"
   V6688 = "K58 WTR LUMPSUM PYTS"
   V6689 = "K59 $  LMPSUM PYTS (BKT)"
   V6690 = "K60 WTR SUPPORT OTRS"
   V6691 = "K61 # OTRS SUPPORTED"
   V6692 = "K63 WTR DEPENDENT OTRS"
   V6693 = "K64 # OTR DEPENDENTS"
   V6694 = "K65 WOULD SUPPORT OTRS"
   V6695 = "K66 SAVINGS?"
   V6696 = "K67 SAVINGS=2 MO INC"
   V6697 = "K68 WTR SVNG LAST 5 YR"
   V6698 = "K69 WTR INFL HARD"
   V6699 = "K70 TYPE 1ST MEN"
   V6700 = "K70 TYPE 2ND MEN"
   V6701 = "K71 DO ABOUT INFL"
   V6702 = "K72 WHAT DONE 1ST MEN"
   V6703 = "K72 WHAT DONE 2ND MEN"
   V6704 = "K73 INFLA VS RETIRE"
   V6705 = "K74 HOW CHANGED 1ST MEN"
   V6706 = "K74 HOW CHANGED 2ND MEN"
   V6707 = "K75 UNION MEMBER-HD"
   V6708 = "K76 WIFE IN FU"
   V6709 = "K77 UNION MEMBER-WF"
   V6710 = "K78 WTR HEALTH LMT-HD"
   V6711 = "K79 HOW MUCH HLTH LMT-HD"
   V6712 = "L1 WTR NEW WIFE"
   V6713 = "L2 EDUCATION-WF"
   V6714 = "L3 WTR OTR SCHLING-WF"
   V6715 = "L4 TYPE OTR SCHLING-WF"
   V6716 = "L5 WTR BA/BS DEGREE-WF"
   V6717 = "L7 WTR ADVANCED DEGREE-W"
   V6718 = "L8 EDUC-WFS FA"
   V6719 = "L9 EDUC-WFS MO"
   V6720 = "L10#YRS WRKD SINCE 18-WF"
   V6721 = "L11#YRS WRKD FULLTIME-WF"
   V6722 = "L12 P TIME WRKD-WF"
   V6723 = "L13 ACC P TIME WRKD-WF"
   V6724 = "M1 WTR NEW HEAD"
   V6725 = "M2 ST GREW UP-FA OF HD"
   V6726 = "M2 CO GREW UP-FA OF HD"
   V6727 = "M2 ST GREW UP-MO OF HD"
   V6728 = "M2 CO GREW UP-MO OF HD"
   V6729 = "M3 OCC-FA OF HD"
   V6730 = "M4 OCC-HDS 1ST JOB"
   V6731 = "M5 # DIFF JOBS OR-HD"
   V6732 = "M6-10 AGE OLDEST KID-HD"
   V6733 = "M6-10 AGE 2ND OLD KID-HD"
   V6734 = "M6-10 AGE 3RD OLD KID-HD"
   V6735 = "M6-10 TOT # KIDS-HD"
   V6736 = "M6-10 # KIDS BY 25-HD"
   V6737 = "M11 # SIBLINGS-HD"
   V6738 = "M12 OLDER SIBS?-HD"
   V6739 = "M13 HD GREW UP FARM OR"
   V6740 = "M14,15 ST GREW UP-HD"
   V6741 = "M14,15 CO GREW UP-HD"
   V6742 = "M16 # REGIONS LIVED-HD"
   V6743 = "M16 # STATES LIVED-HD"
   V6744 = "M17 EVERMVD FOR JOB-HD"
   V6745 = "M18 NOTMV FOR JOB-HD"
   V6746 = "M19 PARENTS POOR OR?"
   V6747 = "M20-21 EDUC-HDS FA"
   V6748 = "M22-23 EDUC-HDS MO"
   V6749 = "M24 WTR HEAD VET"
   V6750 = "M25 #YR WRK SINCE 18-HD"
   V6751 = "M26 # YR WRK FULLTIME-HD"
   V6752 = "M27 P TIME WRKD-HD"
   V6753 = "M27 ACC P TIME WRK-HD"
   V6754 = "M28 EDUCATION-HD"
   V6755 = "M29 WTR OTR TRNG-HD"
   V6756 = "M30 TYPE OTR TRNG-HD"
   V6757 = "M31 TROUBLE READING?-HD"
   V6758 = "M32 WTR OTR SCHLNG-HD"
   V6759 = "M33 TYPE OTR SCHLNG-HD"
   V6760 = "M35 WTR BA/BS DEGREE-HD"
   V6761 = "M36 WTR ADVANCED DEGR-HD"
   V6762 = "M37 RECORD RELIG PREF"
   V6763 = "M38-39 RELIG PREF"
   V6764 = "N1 WHO RESPONDENT"
   V6765 = "N2 # CALLS"
   V6766 = "TOT 1978 FAM $  INC"
   V6767 = "TOT 1978 HEAD LABOR Y"
   V6768 = "TOT MISC TRAN Y H+W"
   V6769 = "TOT 1978 FAM $ Y/NEEDS"
   V6770 = "ANNUAL FOOD STD"
   V6771 = "HEAD 78 AVG HRLY EARNING"
   V6772 = "WIFE 78 AVG HRLY EARNING"
   V6773 = "REGION - 1979 INT"
   V6774 = "REGION 79 HD GREW UP"
   V6775 = "REGION 79 HD FA GREW UP"
   V6776 = "REGION 79 HD MO GREW UP"
   V6777 = "GEOGRAPHIC MOBILITY"
   V6778 = "ACC 78 $  Y COMPONENTS"
   V6779 = "#MINOR ASSGMTS IN 79"
   V6780 = "#MAJOR ASSGMTS IN 79"
   V6781 = "DU VALUE/ROOM - 1979"
   V6782 = "ACTUL MINUS REQ ROOMS 79"
   V6783 = "PERSON/ROOM IN 79"
   V6784 = "# 18 OR OLDER IN 79"
   V6785 = "BKT AGE HEAD 1979"
   V6786 = "BKT AGE WIFE 1979"
   V6787 = "EDUCATION 1979 HEAD"
   V6788 = "EDUCATION 1979 WIFE"
   V6789 = "78 FDRL INCM TAX CREDIT"
   V6790 = "MARITA;L STATUS 79"
   V6791 = "DECILE:78 TOT FAM $  Y"
   V6792 = "DECILE:78 INCOME/NEEDS"
   V6793 = "#CHILDS AGE 1-2"
   V6794 = "#CHILDS AGE 3-5"
   V6795 = "#CHILDS AGE 6-13"
   V6796 = "#FEM CHILDS 14-17"
   V6797 = "#MALE CHILDS 14-17"
   V6798 = "#FEM CHILDS 18-20"
   V6799 = "#MALE CHILDS 18-20"
   V6800 = "#FEM CHILDS 21-29"
   V6801 = "#MALE CHILDS 21-29"
   V6802 = "RACE (FROM 1972)"
   V6803 = "SPLIT SAMPLE FILTER"
   V6804 = "12YR FAM COMP CHANGE"
   V6805 = "79 FAMILY WEIGHT"
   V6806 = "UNSKL M CNTY LABOR SUPPL"
   V6807 = "UNSKL F CNTY LABOR SUPPL"
   V6808 = "UNSKLD JOB MARKET 79"
   V6809 = "TYPIC UNSKL WAGE RATE"
   V6810 = "DIF WAGE MALE VS FEM"
   V6811 = "1979 CNTY UNEMP RATE"
   V6812 = "78-79 CNG MARIT STATUS"
   V6813 = "ST AFDC BASIC NEED ALLOW"
   V6814 = "HOUSEHOLD ID # 79"
   V6815 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V6303=99 THEN V6303=.;
IF V6304=999 THEN V6304=.;
IF V6306=9 THEN V6306=.;
IF V6308=9 THEN V6308=.;
IF V6309=9 THEN V6309=.;
IF V6317=9999 THEN V6317=.;
IF V6318=9999 THEN V6318=.;
IF V6325=9999 THEN V6325=.;
IF V6328=9 THEN V6328=.;
IF V6329=9 THEN V6329=.;
IF V6334=9999 THEN V6334=.;
IF V6335=99999 THEN V6335=.;
IF V6371=9 THEN V6371=.;
IF V6384=99 THEN V6384=.;
IF V6385=9999 THEN V6385=.;
IF V6386=9999 THEN V6386=.;
IF V6387=9999 THEN V6387=.;
IF V6388=9999 THEN V6388=.;
IF V6409=99999 THEN V6409=.;
IF V6430=9 THEN V6430=.;
IF V6458=99 THEN V6458=.;
IF V6459=9 THEN V6459=.;
IF V6460=999 THEN V6460=.;
IF V6462=99 THEN V6462=.;
IF V6464=99 THEN V6464=.;
IF V6467=9 THEN V6467=.;
IF V6468=9 THEN V6468=.;
IF V6469=9 THEN V6469=.;
IF V6470=9 THEN V6470=.;
IF V6471=9 THEN V6471=.;
IF V6472=9 THEN V6472=.;
IF V6473=9 THEN V6473=.;
IF V6474=99999 THEN V6474=.;
IF V6475=9 THEN V6475=.;
IF V6476=9 THEN V6476=.;
IF V6477=9 THEN V6477=.;
IF V6478=9 THEN V6478=.;
IF V6480=9 THEN V6480=.;
IF V6481=99 THEN V6481=.;
IF V6482=9 THEN V6482=.;
IF V6483=9 THEN V6483=.;
IF V6484=9 THEN V6484=.;
IF V6485=99 THEN V6485=.;
IF V6486=9 THEN V6486=.;
IF V6487=9 THEN V6487=.;
IF V6488=9 THEN V6488=.;
IF V6489=9 THEN V6489=.;
IF V6490=9 THEN V6490=.;
IF V6491=9 THEN V6491=.;
IF V6493=9 THEN V6493=.;
IF V6494=9 THEN V6494=.;
IF V6495=9 THEN V6495=.;
IF V6496=9 THEN V6496=.;
IF V6497=99 THEN V6497=.;
IF V6498=99 THEN V6498=.;
IF V6499=999 THEN V6499=.;
IF V6500=99 THEN V6500=.;
IF V6501=9 THEN V6501=.;
IF V6502=9 THEN V6502=.;
IF V6503=9 THEN V6503=.;
IF V6504=9 THEN V6504=.;
IF V6505=9 THEN V6505=.;
IF V6506=99 THEN V6506=.;
IF V6507=9 THEN V6507=.;
IF V6508=99 THEN V6508=.;
IF V6509=9 THEN V6509=.;
IF V6510=99 THEN V6510=.;
IF V6511=9 THEN V6511=.;
IF V6512=99 THEN V6512=.;
IF V6513=9 THEN V6513=.;
IF V6514=99 THEN V6514=.;
IF V6515=99 THEN V6515=.;
IF V6516=99 THEN V6516=.;
IF V6517=9 THEN V6517=.;
IF V6518=9 THEN V6518=.;
IF V6519=9999 THEN V6519=.;
IF V6520=9 THEN V6520=.;
IF V6521=9999 THEN V6521=.;
IF V6522=9999 THEN V6522=.;
IF V6523=9999 THEN V6523=.;
IF V6524=9 THEN V6524=.;
IF V6525=9999 THEN V6525=.;
IF V6526=9 THEN V6526=.;
IF V6527=99 THEN V6527=.;
IF V6528=9 THEN V6528=.;
IF V6529=9999 THEN V6529=.;
IF V6530=99 THEN V6530=.;
IF V6531=99 THEN V6531=.;
IF V6532=9 THEN V6532=.;
IF V6533=9999 THEN V6533=.;
IF V6534=9 THEN V6534=.;
IF V6535=9 THEN V6535=.;
IF V6536=9 THEN V6536=.;
IF V6537=9 THEN V6537=.;
IF V6538=9 THEN V6538=.;
IF V6539=99 THEN V6539=.;
IF V6540=9 THEN V6540=.;
IF V6541=9 THEN V6541=.;
IF V6542=9 THEN V6542=.;
IF V6543=9 THEN V6543=.;
IF V6544=9 THEN V6544=.;
IF V6545=99 THEN V6545=.;
IF V6546=9999 THEN V6546=.;
IF V6547=9 THEN V6547=.;
IF V6548=9 THEN V6548=.;
IF V6549=9 THEN V6549=.;
IF V6550=9 THEN V6550=.;
IF V6551=9999 THEN V6551=.;
IF V6552=9 THEN V6552=.;
IF V6553=9999 THEN V6553=.;
IF V6554=9 THEN V6554=.;
IF V6555=99 THEN V6555=.;
IF V6556=9 THEN V6556=.;
IF V6557=99 THEN V6557=.;
IF V6558=99 THEN V6558=.;
IF V6559=9 THEN V6559=.;
IF V6560=99 THEN V6560=.;
IF V6561=9 THEN V6561=.;
IF V6562=99 THEN V6562=.;
IF V6563=9 THEN V6563=.;
IF V6564=99 THEN V6564=.;
IF V6565=9 THEN V6565=.;
IF V6566=99 THEN V6566=.;
IF V6567=9 THEN V6567=.;
IF V6568=99 THEN V6568=.;
IF V6569=9 THEN V6569=.;
IF V6570=99 THEN V6570=.;
IF V6571=99 THEN V6571=.;
IF V6572=99 THEN V6572=.;
IF V6573=99 THEN V6573=.;
IF V6574=9 THEN V6574=.;
IF V6576=99 THEN V6576=.;
IF V6577=9 THEN V6577=.;
IF V6578=99 THEN V6578=.;
IF V6579=99 THEN V6579=.;
IF V6580=99 THEN V6580=.;
IF V6581=99 THEN V6581=.;
IF V6582=9 THEN V6582=.;
IF V6583=9 THEN V6583=.;
IF V6584=9 THEN V6584=.;
IF V6585=99 THEN V6585=.;
IF V6586=9 THEN V6586=.;
IF V6587=9 THEN V6587=.;
IF V6588=9 THEN V6588=.;
IF V6589=9 THEN V6589=.;
IF V6592=9 THEN V6592=.;
IF V6593=9 THEN V6593=.;
IF V6594=9 THEN V6594=.;
IF V6595=9 THEN V6595=.;
IF V6596=99 THEN V6596=.;
IF V6597=99 THEN V6597=.;
IF V6598=999 THEN V6598=.;
IF V6599=99 THEN V6599=.;
IF V6600=9 THEN V6600=.;
IF V6601=9 THEN V6601=.;
IF V6602=99 THEN V6602=.;
IF V6603=9 THEN V6603=.;
IF V6604=99 THEN V6604=.;
IF V6605=9 THEN V6605=.;
IF V6606=99 THEN V6606=.;
IF V6607=9 THEN V6607=.;
IF V6608=99 THEN V6608=.;
IF V6609=9 THEN V6609=.;
IF V6610=99 THEN V6610=.;
IF V6611=99 THEN V6611=.;
IF V6612=99 THEN V6612=.;
IF V6613=9 THEN V6613=.;
IF V6614=9 THEN V6614=.;
IF V6615=9999 THEN V6615=.;
IF V6616=9999 THEN V6616=.;
IF V6617=9 THEN V6617=.;
IF V6618=9 THEN V6618=.;
IF V6619=99 THEN V6619=.;
IF V6620=99 THEN V6620=.;
IF V6621=99 THEN V6621=.;
IF V6622=99 THEN V6622=.;
IF V6623=9 THEN V6623=.;
IF V6624=99 THEN V6624=.;
IF V6625=9 THEN V6625=.;
IF V6626=9 THEN V6626=.;
IF V6627=99 THEN V6627=.;
IF V6628=9 THEN V6628=.;
IF V6629=99 THEN V6629=.;
IF V6630=99 THEN V6630=.;
IF V6631=9 THEN V6631=.;
IF V6632=99 THEN V6632=.;
IF V6633=9 THEN V6633=.;
IF V6634=99 THEN V6634=.;
IF V6635=9 THEN V6635=.;
IF V6636=99 THEN V6636=.;
IF V6637=9 THEN V6637=.;
IF V6638=99 THEN V6638=.;
IF V6639=9 THEN V6639=.;
IF V6640=99 THEN V6640=.;
IF V6641=9 THEN V6641=.;
IF V6642=99 THEN V6642=.;
IF V6643=99 THEN V6643=.;
IF V6644=99 THEN V6644=.;
IF V6645=99 THEN V6645=.;
IF V6646=9 THEN V6646=.;
IF V6648=99 THEN V6648=.;
IF V6649=9 THEN V6649=.;
IF V6650=99 THEN V6650=.;
IF V6651=99 THEN V6651=.;
IF V6652=99 THEN V6652=.;
IF V6653=99 THEN V6653=.;
IF V6654=9 THEN V6654=.;
IF V6655=9 THEN V6655=.;
IF V6656=9 THEN V6656=.;
IF V6657=9 THEN V6657=.;
IF V6658=9 THEN V6658=.;
IF V6660=9 THEN V6660=.;
IF V6661=9 THEN V6661=.;
IF V6663=99 THEN V6663=.;
IF V6664=99 THEN V6664=.;
IF V6665=9 THEN V6665=.;
IF V6666=9 THEN V6666=.;
IF V6669=9 THEN V6669=.;
IF V6671=99 THEN V6671=.;
IF V6672=9 THEN V6672=.;
IF V6673=99 THEN V6673=.;
IF V6674=9 THEN V6674=.;
IF V6675=99 THEN V6675=.;
IF V6676=9 THEN V6676=.;
IF V6677=999 THEN V6677=.;
IF V6678=9 THEN V6678=.;
IF V6679=9 THEN V6679=.;
IF V6680=9 THEN V6680=.;
IF V6681=9 THEN V6681=.;
IF V6683=9 THEN V6683=.;
IF V6684=9 THEN V6684=.;
IF V6685=9 THEN V6685=.;
IF V6686=9 THEN V6686=.;
IF V6687=9 THEN V6687=.;
IF V6688=9 THEN V6688=.;
IF V6689=9 THEN V6689=.;
IF V6690=9 THEN V6690=.;
IF V6691=9 THEN V6691=.;
IF V6692=9 THEN V6692=.;
IF V6693=9 THEN V6693=.;
IF V6694=9 THEN V6694=.;
IF V6695=9 THEN V6695=.;
IF V6696=9 THEN V6696=.;
IF V6697=9 THEN V6697=.;
IF V6698=9 THEN V6698=.;
IF V6699=99 THEN V6699=.;
IF V6701=9 THEN V6701=.;
IF V6702=99 THEN V6702=.;
IF V6704=9 THEN V6704=.;
IF V6705=99 THEN V6705=.;
IF V6707=9 THEN V6707=.;
IF V6709=9 THEN V6709=.;
IF V6710=9 THEN V6710=.;
IF V6711=9 THEN V6711=.;
IF V6713=99 THEN V6713=.;
IF V6714=9 THEN V6714=.;
IF V6715=9 THEN V6715=.;
IF V6716=9 THEN V6716=.;
IF V6717=9 THEN V6717=.;
IF V6718=9 THEN V6718=.;
IF V6719=9 THEN V6719=.;
IF V6720=99 THEN V6720=.;
IF V6721=99 THEN V6721=.;
IF V6725=99 THEN V6725=.;
IF V6726=999 THEN V6726=.;
IF V6727=99 THEN V6727=.;
IF V6728=999 THEN V6728=.;
IF V6729=9 THEN V6729=.;
IF V6730=9 THEN V6730=.;
IF V6731=9 THEN V6731=.;
IF V6732=99 THEN V6732=.;
IF V6733=99 THEN V6733=.;
IF V6734=99 THEN V6734=.;
IF V6735=99 THEN V6735=.;
IF V6736=9 THEN V6736=.;
IF V6737=9 THEN V6737=.;
IF V6738=9 THEN V6738=.;
IF V6739=9 THEN V6739=.;
IF V6740=99 THEN V6740=.;
IF V6741=999 THEN V6741=.;
IF V6742=9 THEN V6742=.;
IF V6743=9 THEN V6743=.;
IF V6744=9 THEN V6744=.;
IF V6745=9 THEN V6745=.;
IF V6746=9 THEN V6746=.;
IF V6747=9 THEN V6747=.;
IF V6748=9 THEN V6748=.;
IF V6749=9 THEN V6749=.;
IF V6750=99 THEN V6750=.;
IF V6751=99 THEN V6751=.;
IF V6754=99 THEN V6754=.;
IF V6755=9 THEN V6755=.;
IF V6756=9 THEN V6756=.;
IF V6757=9 THEN V6757=.;
IF V6758=9 THEN V6758=.;
IF V6759=9 THEN V6759=.;
IF V6760=9 THEN V6760=.;
IF V6761=9 THEN V6761=.;
IF V6762=9 THEN V6762=.;
IF V6764=9 THEN V6764=.;
IF V6765=9 THEN V6765=.;
IF V6781=99999 THEN V6781=.;
IF V6782=9 THEN V6782=.;
IF V6783=9.9 THEN V6783=.;
IF V6785=9 THEN V6785=.;
IF V6786=9 THEN V6786=.;
IF V6786 GE 0 THEN V6786=.;
IF V6787=9 THEN V6787=.;
IF V6788=9 THEN V6788=.;
*IF V6788 GE 0 THEN V6788=.;
IF V6802=9 THEN V6802=.;
IF V6806=9 THEN V6806=.;
IF V6807=9 THEN V6807=.;
IF V6808=9 THEN V6808=.;
IF V6809=9 THEN V6809=.;
IF V6810=9 THEN V6810=.;
IF V6811=9 THEN V6811=.;
IF V6813=999 THEN V6813=.;
 
file rawdat lrecl=1039;
put    
v6302
v6310
v6319
v6320
v6321
v6326
v6327
v6332
v6333
v6336
v6337
v6338
v6340
v6348
v6349
v6350
v6352
v6364
v6374
v6375
v6376
v6377
v6378
v6379
v6382
v6383
v6397
v6398
v6399
v6404
v6406
v6408
v6411
v6412
v6426
v6427
v6428
v6430
v6431
v6442
v6459
v6461
v6462
v6463
v6464
v6473
v6479
v6480
v6481
v6482
v6484
v6485
v6486
v6492
v6493
v6501
v6515
v6516
v6555
v6559
v6571
v6572
v6591
v6592
v6600
v6611
v6612
v6627
v6631
v6643
v6644
v6654
v6689
v6691
v6710
v6713
v6716
v6724
v6754
v6760
v6766
v6767
v6773
v6778
v6787
v6788
v6790
v6802
v6805
v30295
;

 proc means;
 run; 
